﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Reflection;
using System.Web.Script.Serialization;
using System.Globalization;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class AHOBPRScriptsManager : AHOBPRBaseBO
    {
        private AHOBPRShared _sharedManager = new AHOBPRShared();
       // private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public string GetScriptsBatch()
        {
            string results = string.Empty;
            List<string> userIds = new List<string>();
            try
            {
                Dictionary<String, Object> param = new Dictionary<string, object>();
                List<Object[]> rows = DbUtil.ExecuteSProc("AHOBPR.SP_GetScriptsBatch", param);

                for (int i = 0; i < rows.Count; i++ )
                {
                    userIds.Add(rows[i][0].ToString());
                }
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
            }
            ScriptBatch scriptBatch = new ScriptBatch();
            scriptBatch.userIds = userIds.ToArray();

            JavaScriptSerializer serializer = new JavaScriptSerializer();
            results = serializer.Serialize(scriptBatch);

            return results;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="objectId"></param>
        /// <param name="objectType"></param>
        /// <returns></returns>
        public bool UpdateScriptsBatchStatus(string objectId, string objectType)
        {
            bool result = true;
            try
            {
                Dictionary<String, Object> param = new Dictionary<string, object>();
                param.Add("@objectId", objectId);
                param.Add("@objectType", objectType);
                List<Object[]> rows = DbUtil.ExecuteSProc("AHOBPR.SP_UpdateScriptsBatchStatus", param);
          }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
                result = false;
            }

            return result;
        }
    }
}
